/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.recipe.drink;

import cloud.lemonslice.teastory.potion.EffectRegistry;
import cloud.lemonslice.teastory.recipe.drink.DrinkEffectAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.Fluid;
import xueluoanping.teastory.registry.FluidRegistry;

public final class DrinkEffectManager {
    private static final Map<Fluid, BiConsumer<LivingEntity, Integer>> DRINK_EFFECTS = new HashMap<Fluid, BiConsumer<LivingEntity, Integer>>();

    public static void init() {
        DrinkEffectManager.registerDrinkEffects();
    }

    private static void registerDrinkEffects() {
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.SUGARY_WATER_STILL.get(), DrinkEffectManager.createSimpleDrinkEffect(MobEffects.f_19596_, 2, 0));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.WEAK_GREEN_TEA_STILL.get(), DrinkEffectManager.createSimpleDrinkEffect(EffectRegistry.AGILITY, 2, 0));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.GREEN_TEA_STILL.get(), DrinkEffectManager.createDrinkEffects(new DrinkEffectAttribute(EffectRegistry.AGILITY, 2, 1), new DrinkEffectAttribute(EffectRegistry.EXCITEMENT, 2, 0)));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.STRONG_GREEN_TEA_STILL.get(), DrinkEffectManager.createDrinkEffects(new DrinkEffectAttribute(EffectRegistry.AGILITY, 2, 2), new DrinkEffectAttribute(EffectRegistry.EXCITEMENT, 4, 0)));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.WEAK_BLACK_TEA_STILL.get(), DrinkEffectManager.createSimpleDrinkEffect(MobEffects.f_19616_, 4, 0));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.BLACK_TEA_STILL.get(), DrinkEffectManager.createDrinkEffects(new DrinkEffectAttribute(MobEffects.f_19616_, 4, 1), new DrinkEffectAttribute(EffectRegistry.EXCITEMENT, 4, 0)));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.STRONG_BLACK_TEA_STILL.get(), DrinkEffectManager.createDrinkEffects(new DrinkEffectAttribute(MobEffects.f_19616_, 4, 2), new DrinkEffectAttribute(EffectRegistry.EXCITEMENT, 8, 0)));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.WEAK_WHITE_TEA_STILL.get(), DrinkEffectManager.createSimpleDrinkEffect(MobEffects.f_19598_, 2, 0));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.WHITE_TEA_STILL.get(), DrinkEffectManager.createDrinkEffects(new DrinkEffectAttribute(MobEffects.f_19598_, 2, 1), new DrinkEffectAttribute(EffectRegistry.EXCITEMENT, 2, 0)));
        DrinkEffectManager.registerEffects((Fluid)FluidRegistry.STRONG_WHITE_TEA_STILL.get(), DrinkEffectManager.createDrinkEffects(new DrinkEffectAttribute(MobEffects.f_19598_, 2, 2), new DrinkEffectAttribute(EffectRegistry.EXCITEMENT, 4, 0)));
    }

    public static void registerEffects(Fluid fluid, BiConsumer<LivingEntity, Integer> doEffects) {
        DRINK_EFFECTS.put(fluid, doEffects);
    }

    @Nullable
    public static BiConsumer<LivingEntity, Integer> getEffects(Fluid key) {
        return DRINK_EFFECTS.get(key);
    }

    public static BiConsumer<LivingEntity, Integer> createSimpleDrinkEffect(MobEffect potionIn, int durationIn, int level) {
        return (livingEntity, amount) -> livingEntity.m_7292_(new MobEffectInstance(potionIn, durationIn * amount, level));
    }

    public static BiConsumer<LivingEntity, Integer> createDrinkEffects(DrinkEffectAttribute ... attributes) {
        return (livingEntity, amount) -> {
            for (DrinkEffectAttribute attribute : attributes) {
                livingEntity.m_7292_(new MobEffectInstance(attribute.getPotion(), amount * attribute.getDuration(), attribute.getLevel()));
            }
        };
    }
}

